<?php
require_once '../db_connect.php';

header('Content-Type: application/json');

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Check if asset_id is provided
if (!isset($_GET['asset_id'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Asset ID is required']);
    exit();
}

$assetId = $_GET['asset_id'];

// Mock maintenance history data
$maintenanceHistory = [
    1 => [
        [
            'id' => 1,
            'date' => '2023-04-10',
            'type' => 'Scheduled',
            'description' => 'Regular maintenance - oil change, filters',
            'technician' => 'Mike Smith',
            'cost' => '350',
            'notes' => 'All systems normal'
        ]
    ],
    2 => [
        [
            'id' => 2,
            'date' => '2023-03-15',
            'type' => 'Scheduled',
            'description' => 'Brake system inspection and maintenance',
            'technician' => 'Robert Brown',
            'cost' => '450',
            'notes' => 'Replaced brake pads'
        ]
    ],
    3 => [
        [
            'id' => 3,
            'date' => '2023-02-20',
            'type' => 'Repair',
            'description' => 'Fixed propane regulator',
            'technician' => 'James Wilson',
            'cost' => '275',
            'notes' => 'Replaced faulty regulator'
        ]
    ]
];

// Check if maintenance history exists for the asset
if (!isset($maintenanceHistory[$assetId])) {
    // Return empty array if no maintenance history found
    echo json_encode(['success' => true, 'data' => []]);
    exit();
}

// Return the maintenance history as JSON
echo json_encode(['success' => true, 'data' => $maintenanceHistory[$assetId]]);

// Close the database connection
$conn->close();
?>
