<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 7; // Hardcoding Dispatcher One (ID 7) for now, replace with actual auth
$user_role = 'dispatch'; 
// if (!$user_id || !in_array($user_role, ['dispatch', 'driver'])) { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'GET') {
    // Fetch chat history
    $driver_identifier_filter = $_GET['driver_id'] ?? null; // Get driver identifier from query param
    $driver_id_filter = null;

    // Find the driver's user ID if an identifier is provided
    if ($driver_identifier_filter) {
        $stmt_driver = $conn->prepare("SELECT id FROM users WHERE user_identifier = ? AND role = 'driver'");
        if ($stmt_driver) {
            $stmt_driver->bind_param("s", $driver_identifier_filter);
            if ($stmt_driver->execute()) {
                $result_driver = $stmt_driver->get_result();
                if ($row_driver = $result_driver->fetch_assoc()) {
                    $driver_id_filter = $row_driver['id'];
                }
            }
            $stmt_driver->close();
        }
         if (!$driver_id_filter) {
             // Handle case where driver identifier is invalid, maybe return empty list or error
             echo json_encode([]); 
             exit();
         }
    }

    // Fetch messages involving the dispatcher and optionally the specific driver
    $sql = "SELECT 
                c.id, 
                c.message_text, 
                c.sent_at, 
                sender.role AS sender_role,
                sender.name AS sender_name, -- Could be dispatcher or driver name
                recipient.name AS recipient_name,
                sender.user_identifier AS sender_identifier,
                recipient.user_identifier AS recipient_identifier,
                -- Determine driver details regardless of sender/recipient for filtering
                CASE WHEN sender.role = 'driver' THEN sender.user_identifier ELSE recipient.user_identifier END AS driver_identifier,
                CASE WHEN sender.role = 'driver' THEN sender.name ELSE recipient.name END AS driver_name
            FROM communications c
            JOIN users sender ON c.sender_user_id = sender.id
            LEFT JOIN users recipient ON c.recipient_user_id = recipient.id -- Recipient might be null for broadcast?
            WHERE (c.sender_user_id = ? OR c.recipient_user_id = ?)"; // Messages sent by or to the dispatcher

    $params = [$user_id, $user_id];
    $types = "ii";

    if ($driver_id_filter) {
        // Filter further for messages involving the specific driver
        $sql .= " AND (c.sender_user_id = ? OR c.recipient_user_id = ?)";
        $params[] = $driver_id_filter;
        $params[] = $driver_id_filter;
        $types .= "ii";
    }
    
    $sql .= " ORDER BY c.sent_at ASC"; // Order chronologically

    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    $stmt->bind_param($types, ...$params);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $messages = [];
        while ($row = $result->fetch_assoc()) {
            // Format timestamp
             if ($row['sent_at']) {
                 $dt = new DateTime($row['sent_at']);
                 // Could format differently here if needed, e.g., relative time
                 $row['sent_at_formatted'] = $dt->format('Y-m-d H:i:s'); 
             }
            $messages[] = $row;
        }
        echo json_encode($messages);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} elseif ($method == 'POST') {
    // Save a new message sent by the dispatcher
     if ($user_role !== 'dispatch') {
        http_response_code(403); 
        echo json_encode(['error' => 'Only dispatchers can send messages via this endpoint.']);
        exit();
    }
    
    $data = json_decode(file_get_contents('php://input'), true);
    $recipient_identifier = $data['recipient_user_identifier'] ?? null;
    $message_text = $data['message_text'] ?? null;

    if (!$recipient_identifier || !$message_text) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing recipient identifier or message text.']);
        exit();
    }

    // Find recipient user ID
    $recipient_id = null;
    $stmt_recipient = $conn->prepare("SELECT id FROM users WHERE user_identifier = ?");
     if ($stmt_recipient) {
        $stmt_recipient->bind_param("s", $recipient_identifier);
        if ($stmt_recipient->execute()) {
            $result_recipient = $stmt_recipient->get_result();
            if ($row_recipient = $result_recipient->fetch_assoc()) {
                $recipient_id = $row_recipient['id'];
            }
        }
        $stmt_recipient->close();
    }

    if (!$recipient_id) {
         http_response_code(404);
         echo json_encode(['error' => 'Recipient user not found.']);
         exit();
    }

    // Insert the message
    $sql = "INSERT INTO communications (sender_user_id, recipient_user_id, sender_role, message_text, sent_at) 
            VALUES (?, ?, ?, ?, NOW())";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare insert statement: ' . $conn->error]);
        exit();
    }

    $sender_role_db = 'dispatch'; // Explicitly set sender role
    $stmt->bind_param("iiss", $user_id, $recipient_id, $sender_role_db, $message_text);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Message sent.', 'message_id' => $stmt->insert_id]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to send message: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>
