<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// Verify dispatcher role if needed
// $user_role = $_SESSION['user_role'] ?? null;
// if ($user_role !== 'dispatch') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---

if ($method == 'GET') {
    // Fetch active drivers
    $sql = "SELECT 
                id, 
                user_identifier, 
                name 
            FROM users 
            WHERE role = 'driver' AND status = 'active'
            ORDER BY name ASC";
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $drivers = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $drivers[] = $row;
        }
        echo json_encode($drivers);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>