<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 2; // Hardcoding Driver Alice Brown (ID 2) for now, replace with actual auth
$user_role = 'driver'; 
// if (!$user_id || $user_role !== 'driver') { /* Handle unauthorized */ }
// --- End Authentication Placeholder ---


if ($method == 'GET') {
     // Ensure the user is a driver and has an ID
    if (!$user_id || $user_role !== 'driver') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    // Fetch vehicle(s) currently assigned to this driver
    $sql = "SELECT 
                v.id, 
                v.vehicle_identifier,
                v.name 
            FROM vehicles v
            JOIN vehicle_assignments va ON v.id = va.vehicle_id
            WHERE va.user_id = ? AND va.status = 'active' 
            ORDER BY v.vehicle_identifier ASC";
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    $stmt->bind_param("i", $user_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $vehicles = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $vehicles[] = $row;
        }
        // If no active assignment, maybe fetch the last assigned vehicle? Or return empty.
        echo json_encode($vehicles); 
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>