<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 5; // Hardcoding Field Rep One (ID 5) for now, replace with actual auth
$user_role = 'field_rep'; 
// --- End Authentication Placeholder ---


if ($method == 'GET') {
    // Ensure the user is a field rep and has an ID
    if (!$user_id || $user_role !== 'field_rep') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    // Fetch service records created by this field rep
    $sql = "SELECT 
                sr.id AS service_record_db_id, 
                sr.record_identifier, 
                sr.completion_date, 
                sr.service_type, 
                sr.summary, 
                sr.parts_used, 
                sr.hours_spent,
                v.vehicle_identifier,
                ft.task_identifier AS field_task_identifier, -- Get related field task ID
                mt.task_identifier AS maintenance_task_identifier -- Get related maintenance task ID
            FROM service_records sr
            JOIN vehicles v ON sr.vehicle_id = v.id
            LEFT JOIN field_tasks ft ON sr.field_task_id = ft.id -- Join to get field task identifier
            LEFT JOIN maintenance_tasks mt ON sr.maintenance_task_id = mt.id -- Join to get maintenance task identifier
            WHERE sr.user_id = ?
            ORDER BY sr.completion_date DESC, sr.created_at DESC";
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    $stmt->bind_param("i", $user_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $records = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
             // Format date if not null
            if ($row['completion_date']) {
                 $date = new DateTime($row['completion_date']);
                 $row['completion_date'] = $date->format('Y-m-d');
            }
            // Decode JSON parts_used if needed (client-side might handle it too)
            // $row['parts_used'] = json_decode($row['parts_used'] ?? '[]'); 
            $records[] = $row;
        }
        echo json_encode($records);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>