<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// --- Authentication Placeholder ---
// In a real app, verify the user's token/session and get their ID and role
// $user_id = $_SESSION['user_id'] ?? null; 
// $user_role = $_SESSION['user_role'] ?? null;
$user_id = 5; // Hardcoding Field Rep One (ID 5) for now, replace with actual auth
$user_role = 'field_rep'; 
// --- End Authentication Placeholder ---


if ($method == 'GET') {
    // Ensure the user is a field rep and has an ID
    if (!$user_id || $user_role !== 'field_rep') {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Access denied.']);
        exit();
    }

    // Fetch tasks assigned to this field rep
    $sql = "SELECT 
                ft.id AS field_task_db_id, 
                ft.task_identifier, 
                ft.type, 
                ft.description, 
                ft.status, 
                ft.priority, 
                ft.due_date,
                v.vehicle_identifier,
                y.name AS yard_name
            FROM field_tasks ft
            JOIN vehicles v ON ft.vehicle_id = v.id
            LEFT JOIN yards y ON ft.yard_id = y.id
            WHERE ft.assigned_to_user_id = ?
            ORDER BY FIELD(ft.priority, 'High', 'Medium', 'Low'), ft.due_date ASC, ft.created_at ASC";
            
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
        exit();
    }
    
    $stmt->bind_param("i", $user_id);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $tasks = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
             // Format date if not null
            if ($row['due_date']) {
                 $date = new DateTime($row['due_date']);
                 $row['due_date'] = $date->format('Y-m-d');
            }
            $tasks[] = $row;
        }
        echo json_encode($tasks);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>