<?php
require_once '../db_connect.php'; // Adjust path as needed

header('Content-Type: application/json');

// --- Authentication Placeholder ---
// In a real app, you'd verify the user's session/token and ensure they have owner privileges
// --- End Authentication Placeholder ---

// In a real app, you might want to add filtering options (by date range, etc.)

$sql = "SELECT 
            (SELECT COUNT(id) FROM inspections) AS inspections,
            (SELECT SUM(hours_spent * 50) FROM service_records) AS financials,
            (SELECT COUNT(id) FROM users) AS userAccounts";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
    exit();
}

if ($stmt->execute()) {
    $result = $stmt->get_result();
    $stats = $result->fetch_assoc();
    // Convert numeric values to integers
    $stats['inspections'] = (int)$stats['inspections'];
    $stats['userAccounts'] = (int)$stats['userAccounts'];
    // Format financials
    // $stats['financials'] = '$' . number_format((float)$stats['financials'], 2, '.', '');
    echo json_encode($stats);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>