<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// --- Authentication Placeholder ---
// In a real app, you'd verify the user's session/token and ensure they have owner privileges
// --- End Authentication Placeholder ---

$sql = "SELECT id, vehicle_identifier AS assetName, status, yard_id, name AS yard_name FROM vehicles v LEFT JOIN yards y ON v.yard_id = y.id ORDER BY vehicle_identifier";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
    exit();
}

if ($stmt->execute()) {
    $result = $stmt->get_result();
    $assets = [];
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        $assets[] = [
            'id' => (int)$row['id'],
            'assetName' => $row['assetName'],
            'location' => $row['yard_name'] ?? 'Unknown',
            'status' => $row['status']
        ];
    }
    echo json_encode($assets);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>