<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");
require_once 'db_connect.php';

$userId = verifyRole($conn, 'owner');
$stmt = $conn->prepare("SELECT COUNT(*) as total FROM inspections");
$stmt->execute();
$totalInspections = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM users");
$stmt->execute();
$totalUsers = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM vehicles");
$stmt->execute();
$totalVehicles = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

echo json_encode(['success' => true, 'data' => ['totalInspections' => $totalInspections, 'financials' => '$0', 'totalUsers' => $totalUsers]]);