
<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

// --- Authentication Placeholder ---
// In a real app, you'd verify the user's session/token and ensure they have owner privileges
// --- End Authentication Placeholder ---

// No specific input needed for this example (fetching all history)
// In a real app, you might want to add filtering options (by vehicle, date range, etc.)

$sql = "SELECT 
            i.id, 
            v.vehicle_identifier, 
            i.inspection_date, 
            u.name AS inspector_name, 
            i.status
        FROM inspections i
        JOIN vehicles v ON i.vehicle_id = v.id
        JOIN users u ON i.inspector_id = u.id
        ORDER BY i.inspection_date DESC";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
    exit();
}

if ($stmt->execute()) {
    $result = $stmt->get_result();
    $history = [];
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        // Format date if needed
        if ($row['inspection_date']) {
            $date = new DateTime($row['inspection_date']);
            $row['inspection_date'] = $date->format('Y-m-d');
        }
        $history[] = $row;
    }
    echo json_encode($history);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
