<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// Assuming yard_id might be needed later, e.g., from session or request
// $yard_id = $_SESSION['yard_id'] ?? null; // Example: Get yard_id from session
$yard_id = 1; // Hardcoding for now based on dummy data structure, adjust as needed

if ($method == 'GET') {
    // Fetch inspections, potentially filtered by yard_id if available
    // Joining with vehicles to get the identifier
    $sql = "SELECT i.id, v.vehicle_identifier, i.inspection_date, i.status 
            FROM inspections i
            JOIN vehicles v ON i.vehicle_id = v.id";
            
    // Example filtering by yard_id if needed in a real scenario
    // if ($yard_id) {
    //     $sql .= " WHERE i.yard_id = ?";
    //     $stmt = $conn->prepare($sql);
    //     if ($stmt === false) {
    //         http_response_code(500);
    //         echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
    //         exit();
    //     }
    //     $stmt->bind_param("i", $yard_id);
    // } else {
        $stmt = $conn->prepare($sql);
         if ($stmt === false) {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
            exit();
        }
    // }


    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $inspections = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $inspections[] = $row;
        }
        echo json_encode($inspections);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} elseif ($method == 'POST') {
    // Handle status updates (Approve/Flag) - Placeholder
    $data = json_decode(file_get_contents('php://input'), true);
    $action = $data['action'] ?? null;
    $inspection_id = $data['id'] ?? null;

    if ($inspection_id && ($action == 'approve' || $action == 'flag')) {
        $new_status = ($action == 'approve') ? 'approved' : 'flagged';

        $sql = "UPDATE inspections SET status = ? WHERE id = ?";
        // Add yard_id check if necessary: "UPDATE inspections SET status = ? WHERE id = ? AND yard_id = ?"
        
        $stmt = $conn->prepare($sql);
         if ($stmt === false) {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to prepare update statement: ' . $conn->error]);
            exit();
        }
        
        // Bind parameters: $stmt->bind_param("si", $new_status, $inspection_id);
        // If using yard_id: $stmt->bind_param("sii", $new_status, $inspection_id, $yard_id);
        $stmt->bind_param("si", $new_status, $inspection_id);


        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                echo json_encode(['success' => true, 'message' => "Inspection $inspection_id status updated to $new_status."]);
            } else {
                 // Check if the inspection exists and belongs to the yard if filtering
                http_response_code(404); // Or 403 Forbidden
                echo json_encode(['error' => "Inspection not found or no change needed."]);
            }
        } else {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to update inspection status: ' . $stmt->error]);
        }
        $stmt->close();

    } else {
        http_response_code(400); // Bad Request
        echo json_encode(['error' => 'Invalid action or missing inspection ID.']);
    }

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>