<?php
require_once '../db_connect.php'; // Adjust path as needed
header("Access-Control-Allow-Origin: *"); // Allow all origins (adjust for production)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

// Assuming yard_id might be needed later, e.g., from session or request
// $yard_id = $_SESSION['yard_id'] ?? null; // Example: Get yard_id from session
$yard_id = 4; // Hardcoding Yard Alpha (ID 4) for now based on dummy data, adjust as needed

if ($method == 'GET') {
    // Fetch vehicles, joining with types, yards, and assignments/users
    $sql = "SELECT 
                v.id AS vehicle_db_id, 
                v.vehicle_identifier, 
                v.status, 
                v.location_text, 
                v.maintenance_due_date,
                vt.name AS vehicle_type_name,
                y.name AS yard_name,
                u.name AS assigned_driver_name
            FROM vehicles v
            LEFT JOIN vehicle_types vt ON v.vehicle_type_id = vt.id
            LEFT JOIN yards y ON v.yard_id = y.id
            LEFT JOIN (
                -- Subquery to get the currently active driver assignment for each vehicle
                SELECT va.vehicle_id, va.user_id
                FROM vehicle_assignments va
                WHERE va.status = 'active' 
                -- Optional: Add date range checks if assignments are time-bound
            ) current_va ON v.id = current_va.vehicle_id
            LEFT JOIN users u ON current_va.user_id = u.id";

    // Example filtering by yard_id if needed in a real scenario
    // if ($yard_id) {
    //     $sql .= " WHERE v.yard_id = ?";
    //     $stmt = $conn->prepare($sql);
    //     if ($stmt === false) {
    //         http_response_code(500);
    //         echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
    //         exit();
    //     }
    //     $stmt->bind_param("i", $yard_id);
    // } else {
        $stmt = $conn->prepare($sql);
         if ($stmt === false) {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to prepare statement: ' . $conn->error]);
            exit();
        }
    // }

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $vehicles = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            // Format date if not null
            if ($row['maintenance_due_date']) {
                 $date = new DateTime($row['maintenance_due_date']);
                 $row['maintenance_due_date'] = $date->format('Y-m-d'); // Format as YYYY-MM-DD
            } else {
                 $row['maintenance_due_date'] = null; // Keep it null if it is null
            }
            $vehicles[] = $row;
        }
        echo json_encode($vehicles);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to execute query: ' . $stmt->error]);
    }
    $stmt->close();

} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['error' => 'Method not allowed.']);
}

$conn->close();
?>